/*
 ##############################################################################
 #
 # File:         trice/clib/src/test/test1430.c
 # RCS:		"@(#)$Revision: 1.2 $ $Date: 94/03/09 13:20:51 $"
 # Description:  Source for for diagnostic program for E1430
 # Author:       Doug Passey
 # Created:      
 # Language:     C
 # Package:      
 # Status:       "@(#)$State: Exp $"
 #
 # (C) Copyright 1993, Hewlett-Packard Company, all rights reserved.
 #
 ##############################################################################
 #
 # Please add additional comments here
 #
 # Modification history:
 #
 #  
 ##############################################################################
*/

#include <stdlib.h>
#include <stdio.h>
#include "e1430.h"

void print_usage(char *prog)
{
  printf("Usage: %s <logical address> \n", prog);
  exit(-1);
}


main(argc, argv)
int argc;
char *argv[];
{
  SHORTSIZ16 la;
  SHORTSIZ16 groupID;
  SHORTSIZ16 error;

  if(argc < 2) {
    print_usage(argv[0]);
  }

  if(1 != sscanf(argv[1], "%hd", &la)) {
    printf("Invalid logical address: %s\n", argv[1]);
    print_usage(argv[0]);
    exit(-1);
  }

  if(la < 1 || la > 255) {
    printf("Logical address, %hd, out of range: 1 -> 255\n", la);
    print_usage(argv[0]);
    exit(-1);
  }


  error = e1430_init_io_driver();
  if(error) {
    printf("e1430_init_io_driver() failed\n");
    printf("  error: %d, %s\n", error, e1430_get_error_string() );
    exit(-1);
  }


  groupID = e1430_create_module_group(1, &la);
  if(groupID == 0) {
    printf("Can't create module group with module at la = %hd\n", la);
    exit(-1);
  }

  error = e1430_diagnostics(la, MEM_TEST_FLAG | REG_ACCESS_TEST_FLAG);
  if(error) {
    printf("\nE1430 at logical address %hd FAILED diagnostics\n", la);
    printf("\n%s\n", e1430_get_error_string());
    exit(-1);
  }else{
    printf("\nE1430 at logical address %hd PASSED diagnostics\n", la);
    exit(0);
  }
  return 0;
}
